package fm.qingting.demo;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import fm.qingting.qtsdk.QTException;
import fm.qingting.qtsdk.QTSDK;
import fm.qingting.qtsdk.api.QTUserCenter;
import fm.qingting.qtsdk.callbacks.QTCallback;

public class PayTestActivity extends Activity {

    private EditText etItemId;
    private EditText etProgram;
    private Button btPay;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_pay);
        etItemId = findViewById(R.id.et_item);
        etProgram = findViewById(R.id.et_program);
        btPay = findViewById(R.id.bt_pay);
        btPay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (TextUtils.isEmpty(etItemId.getText().toString().trim())) {
                    Toast.makeText(getBaseContext(), "商品id为空", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (!TextUtils.isEmpty(QTUserCenter.getQTUserId())) {
                    QTSDK.startQTPay(etItemId.getText().toString().trim(), etProgram.getText().toString().trim(), new QTCallback<String>() {
                                @Override
                                public void done(String result, QTException e) {
                                    if (result != null) {
                                        switch (result) {
                                            case "0":
                                                result = "成功";
                                                break;
                                            case "1":
                                                result = "失败";
                                                break;
                                            case "2":
                                                result = "取消";
                                                break;
                                            case "3":
                                                result = "未知";
                                                break;
                                            case "4":
                                                result = "已购";
                                                break;
                                        }
                                        Toast.makeText(getBaseContext(), "购买回调状态:" + result, Toast.LENGTH_SHORT).show();
                                    } else {
                                        //处理异常
                                        Toast.makeText(getBaseContext(), "购买回调异常", Toast.LENGTH_SHORT).show();
                                    }
                                }
                            }
                    );
                } else {
                    Toast.makeText(getBaseContext(), "请先登录", Toast.LENGTH_SHORT).show();
                }
            }
        });
    }
}

